


full_data_df <- as.data.frame(cbind(Gold_dt$Gold_Date, Amazon_dt$Amazon_Open, Boeing_dt$Boeing_Open, Cattle_dt$Cattle_Open, Cocoa_dt$Cocoa_Open, 
                                    Coffee_dt$Coffee_Open, Crude_dt$Crude_Open, Gold_dt$Gold_Open, NYSE_dt$NYSE_Open, Silver_dt$Silver_Open, 
                                    sp500_dt$sp500_Open, Sugar_dt$Sugar_Open, Wheat_dt$Wheat_Open))

colnames(full_data_df) <- c("Date", "Amazon", "Boeing", "Cattle", "Cocoa", "Coffee", "Crude", "Gold", "NYSE", "Silver", "sp500", "Sugar", "Wheat")

full_data_df$Date <- Gold_dt$Gold_Date

# class(full_data_df$Date)

# ----- #

# summary(full_data_lm <- lm(Gold_dt$Gold_Open ~ Amazon_dt$Amazon_Open + Boeing_dt$Boeing_Open + Cattle_dt$Cattle_Open +
#                    Cocoa_dt$Cocoa_Open + Coffee_dt$Coffee_Open + Crude_dt$Crude_Open + NYSE_dt$NYSE_Open +
#                    Silver_dt$Silver_Open + sp500_dt$sp500_Open + Sugar_dt$Sugar_Open + Wheat_dt$Wheat_Open))
 
# Ruling Amazon out because of high p-value

# summary(lm(Gold_dt$Gold_Open ~ Boeing_dt$Boeing_Open + Cattle_dt$Cattle_Open + 
#             Cocoa_dt$Cocoa_Open + Coffee_dt$Coffee_Open + Crude_dt$Crude_Open + NYSE_dt$NYSE_Open +
#             Silver_dt$Silver_Open + sp500_dt$sp500_Open + Sugar_dt$Sugar_Open + Wheat_dt$Wheat_Open))

# Ruling out Boeing, Cocoa, NYSE, and Wheat due to low Estimate values

# summary(lm(Gold_dt$Gold_Open ~ Cattle_dt$Cattle_Open + Coffee_dt$Coffee_Open + Crude_dt$Crude_Open + 
#          Silver_dt$Silver_Open + sp500_dt$sp500_Open + Sugar_dt$Sugar_Open))

# Removing sp500 because it tracks amazon and boeing, not gold.

# summary(lm(Gold_dt$Gold_Open ~ Cattle_dt$Cattle_Open + Coffee_dt$Coffee_Open + 
#   Crude_dt$Crude_Open + Silver_dt$Silver_Open + Sugar_dt$Sugar_Open))

# Removing Silver due to low Estimate value

# summary(lm(Gold_dt$Gold_Open ~ Cattle_dt$Cattle_Open + Coffee_dt$Coffee_Open + 
#            Crude_dt$Crude_Open + Sugar_dt$Sugar_Open))

# Removing cattle and coffee due to low Estimate values

# summary(lm(Gold_dt$Gold_Open ~ Crude_dt$Crude_Open + Sugar_dt$Sugar_Open))

# Crude and Sugar survive with high t-values, low p-values, and an R-squared 
# indicating 33% or variation in the price of the dependent varible can be 
# explained by the independent variables. Finally, the Estimate value for each 
# independent variable makes them worth including in the model


# ***** # # ***** # # ***** # # ***** # # ***** # # ***** # # ***** # # ***** # 


amazon_full_scaled <- (Amazon_dt$Amazon_Open - mean(Amazon_dt$Amazon_Open)) / sd(Amazon_dt$Amazon_Open)

boeing_full_scaled <- (Boeing_dt$Boeing_Open - mean(Boeing_dt$Boeing_Open)) / sd(Boeing_dt$Boeing_Open)

cattle_full_scaled <- (Cattle_dt$Cattle_Open - mean(Cattle_dt$Cattle_Open)) / sd(Cattle_dt$Cattle_Open)

cocoa_full_scaled <- (Cocoa_dt$Cocoa_Open - mean(Cocoa_dt$Cocoa_Open)) / sd(Cocoa_dt$Cocoa_Open)

coffee_full_scaled <- (Coffee_dt$Coffee_Open - mean(Coffee_dt$Coffee_Open)) / sd(Coffee_dt$Coffee_Open)

crude_full_scaled  <- (Crude_dt$Crude_Open - mean(Crude_dt$Crude_Open)) / sd(Crude_dt$Crude_Open)

gold_full_scaled   <- (Gold_dt$Gold_Open - mean(Gold_dt$Gold_Open)) / sd(Gold_dt$Gold_Open)

nyse_full_scaled <- (NYSE_dt$NYSE_Open - mean(NYSE_dt$NYSE_Open)) / sd(NYSE_dt$NYSE_Open)

silver_full_scaled <- (Silver_dt$Silver_Open - mean(Silver_dt$Silver_Open)) / sd(Silver_dt$Silver_Open)

sp500_full_scaled <- (sp500_dt$sp500_Open - mean(sp500_dt$sp500_Open)) / sd(sp500_dt$sp500_Open)

sugar_full_scaled <- (Sugar_dt$Sugar_Open - mean(Sugar_dt$Sugar_Open)) / sd(Sugar_dt$Sugar_Open)

wheat_full_scaled <- (Wheat_dt$Wheat_Open - mean(Wheat_dt$Wheat_Open)) / sd(Wheat_dt$Wheat_Open)



# ----- #

summary(lm(Gold_dt$Gold_Open ~ Coffee_dt$Coffee_Open + Crude_dt$Crude_Open + 
            Silver_dt$Silver_Open + Sugar_dt$Sugar_Open + Wheat_dt$Wheat_Open))



##### EOF #####

paste("End of File")

###############









